using System;

namespace  com.swvoyages.reservation {

	///
	/// <summary>Cette classe constitue l'interface du service d'accs 
	/// au systme de rservation de la centrale de rservation SW-Voyages.
	///	</summary>
	///
	public interface IReservationService {

		///
		/// <summary>Recherche de disponibilits pour la rservation d'un
		/// voyage.</summary>
		///
		/// <param name="passengers">le nombre de passagers</param>
		/// <param name="from">la localit de dpart</param>
		/// <param name="to">la localit d'arrive</param>
		/// <param name="roundTrip">aller retour/aller simple</param>
		/// <param name="departureDay">jour de dpart</param>
		/// <param name="departureMonth">mois de dpart</param> 
		/// <param name="departureYear">anne de dpart</param>
		/// <param name="arrivalDay">jour d'arrive</param>
		/// <param name="arrivalMonth">mois d'arrive</param> 
		/// <param name="arrivalYear">anne d'arrive</param>
		/// <param name="hotelRequested">rservation htelire demande
		/// </param>
		/// <param name="carRequested">rservation automobile demande
		/// </param>
		///
		/// <returns>le n de rservation affect  la recherche de
		///	disponibilits du client</returns>
		///
		int search(int passengers, String from, String to, bool roundTrip, 
			int departureDay, int departureMonth, int departureYear, int arrivalDay, int arrivalMonth, 
			int arrivalYear, bool hotelRequested, bool carRequested);

		///
		/// <summary>Confirmation de la rservation dont l'identifiant est
		/// pass en paramtre.</summary>
		///
		/// <param name="reservationId">le n de la rservation  confirmer
		/// </param>
		/// <param name="departureChoice">l'identifiant de la disponibilit 
		/// arienne (vol aller) choisie</param>
		/// <param name="arrivalChoice">l'identifiant de la disponibilit
		///	arienne (vol retour) choisie</param>
		/// <param name="hotelChoice">l'identifiant de la disponibilit
		///	htelire choisie</param>
		/// <param name="carChoice">l'identifiant de la disponibilit
		///	automobile choisie</param>
		///
		/// <returns><code>true</code> si la confirmation s'est bien
		///	passe; <code>false</code> sinon</returns>
		///
		bool book(int reservationId, int departureChoice, int arrivalChoice,
			int hotelChoice, int carChoice);

		///
		/// <summary>Annulation de la rservation dont l'identifiant est
		/// pass en paramtre.</summary>
		///
		/// <param name="reservationId">le n de la rservation  annuler
		/// </param>
		///
		/// <returns><code>true</code> si l'annulation s'est bien
		///	passe; <code>false</code> sinon</returns>
		///
		bool cancel(int reservationId);

		///
		/// <summary>Renvoie les disponibilits de la centrale de 
		/// rservation arienne pour la rservation locale dont 
		/// l'identifiant est pass en paramtre.</summary>
		///
		/// <param name="reservationId">l'identifiant de la	rservation 
		/// locale</param>
		///
		/// <returns>les disponibilits de la centrale de rservation 
		/// arienne pour la rservation locale dont l'identifiant est 
		///	pass en paramtre</returns>
		///
		AirAvailability[] getAirAvailabilities(int reservationId);

		///
		/// <summary>Renvoie les disponibilits de la centrale de 
		/// rservation automobile pour la rservation locale dont 
		/// l'identifiant est pass en paramtre.</summary>
		///
		/// <param name="reservationId">l'identifiant de la	rservation 
		/// locale</param>
		///
		/// <returns>les disponibilits de la centrale de rservation 
		/// automobile pour la rservation locale dont l'identifiant est 
		///	pass en paramtre</returns>
		///
		CarAvailability[] getCarAvailabilities(int reservationId);

		///
		/// <summary>Renvoie les disponibilits de la centrale de 
		/// rservation htelire pour la rservation locale dont 
		/// l'identifiant est pass en paramtre.</summary>
		///
		/// <param name="reservationId">l'identifiant de la	rservation 
		/// locale</param>
		///
		/// <returns>les disponibilits de la centrale de rservation 
		/// htelire pour la rservation locale dont l'identifiant est 
		///	pass en paramtre</returns>
		///
		HotelAvailability[] getHotelAvailabilities(int reservationId);
	}
}